CREATE OR REPLACE VIEW public.v_cupomfiscal_tef
AS SELECT vd.cd_emp,
    vd.cd_filial,
    vd.dt_vd,
    vd.cd_cx,
    vd.cd_vd,
    vd.nr_ecf,
        CASE
            WHEN COALESCE(tef.cd_adm_cartao, 0::numeric) > 0::numeric THEN tef.cd_adm_cartao
            WHEN tef.cd_adm_cartao = 0::numeric AND tef.tp_adm = 6 THEN ( SELECT rc_adm_cartao.cd_adm_cartao
               FROM rc_adm_cartao
              WHERE rc_adm_cartao.cd_emp = tef.cd_emp AND rc_adm_cartao.tp_adm = tef.tp_adm::numeric AND rc_adm_cartao.parc = tef.qt_parc::numeric AND rc_adm_cartao.sts_adm = 0
             LIMIT 1)
            ELSE NULL::numeric
        END AS cd_conv,
        CASE
            WHEN COALESCE(tef.cd_adm_cartao, 0::numeric) > 0::numeric THEN adm.nm_usual
            WHEN tef.cd_adm_cartao = 0::numeric AND tef.tp_adm = 6 THEN ( SELECT rc_adm_cartao.nm_usual
               FROM rc_adm_cartao
              WHERE rc_adm_cartao.cd_emp = tef.cd_emp AND rc_adm_cartao.tp_adm = tef.tp_adm::numeric AND rc_adm_cartao.parc = tef.qt_parc::numeric AND rc_adm_cartao.sts_adm = 0
             LIMIT 1)
            ELSE NULL::character varying
        END AS nm_conv,
        CASE adm.tp_adm
            WHEN 6 THEN 1
            ELSE 0
        END AS tp_cartao,
    tef.vl_cartao AS vlr_cartao,
    tef.vl_saque_cartao AS vlr_saque,
        CASE adm.tp_adm
            WHEN 6 THEN adm.parc
            ELSE tef.qt_parc::numeric
        END AS qt_parc,
    tef.cod_rede,
    tef.cod_bandeira,
    tef.cod_modalidade,
        CASE
            WHEN COALESCE(tef.nsu_tef, 0::numeric) > 0::numeric AND tef.nsu_tef <> 1::numeric THEN tef.nsu_tef
            WHEN tef.nsu_tef = 1::numeric THEN tef.cd_trn_tef
            WHEN COALESCE(tef.nsu_tef, 0::numeric) = 0::numeric THEN tef.cd_trn_tef
            ELSE NULL::numeric
        END AS nr_transacao,
        CASE
            WHEN COALESCE(tef.nr_autorizacao, '0'::character varying)::text > '0'::text AND tef.nr_autorizacao::text <> '1'::text THEN tef.nr_autorizacao
            WHEN tef.nr_autorizacao::text = '1'::text THEN tef.cd_trn_tef::character varying
            WHEN tef.nr_autorizacao::text = '0'::text THEN tef.cd_trn_tef::character varying
            ELSE NULL::character varying
        END AS nr_autorizacao,
        CASE
            WHEN tef.gerenciador_tef = 1 THEN 'scope'::text
            WHEN tef.trn_pos = 1 THEN 'pos'::text
            ELSE 'sitef'::text
        END AS tef_gateway,
    cred.cd_parc,
    cred.dt_parc,
    cred.vl_parc AS vlr_parc,
    vd.flag_consolidado
   FROM pdv_vd vd
     JOIN pdv_vd_tef tef ON vd.cd_emp = tef.cd_emp AND vd.cd_filial = tef.cd_filial AND vd.cd_vd = tef.cd_vd
     LEFT JOIN rc_adm_cartao adm ON tef.cd_emp = adm.cd_emp AND tef.cd_adm_cartao = adm.cd_adm_cartao
     LEFT JOIN pdv_vd_cred cred ON vd.cd_emp = cred.cd_emp AND vd.cd_filial = cred.cd_filial AND vd.cd_vd = cred.cd_vd
  WHERE vd.st_vd > '-1'::integer::numeric AND COALESCE(vd.vlr_cartao, 0::numeric) <> 0::numeric;
